/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import DistantHorizons.libraries.joml.FrustumIntersection;
import DistantHorizons.libraries.joml.Matrix4f;
import DistantHorizons.libraries.joml.Vector3f;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiCullingFrustum;
import com.seibel.distanthorizons.api.objects.math.DhApiMat4f;
import com.seibel.distanthorizons.core.util.math.Mat4f;

public class DhFrustumBounds
implements IDhApiCullingFrustum {
    private final FrustumIntersection frustum;
    private final Vector3f boundsMin = new Vector3f();
    private final Vector3f boundsMax = new Vector3f();
    public float worldMinY;
    public float worldMaxY;

    public DhFrustumBounds() {
        this.frustum = new FrustumIntersection();
    }

    @Override
    public void update(int worldMinBlockY, int worldMaxBlockY, DhApiMat4f dhWorldViewProjection) {
        this.worldMinY = worldMinBlockY;
        this.worldMaxY = worldMaxBlockY;
        Matrix4f worldViewProjection = new Matrix4f(Mat4f.createJomlMatrix(dhWorldViewProjection));
        this.frustum.set(worldViewProjection);
        Matrix4f matWorldViewProjectionInv = new Matrix4f(worldViewProjection).invert();
        matWorldViewProjectionInv.frustumAabb(this.boundsMin, this.boundsMax);
    }

    @Override
    public boolean intersects(int lodBlockPosMinX, int lodBlockPosMinZ, int lodBlockWidth, int lodDetailLevel) {
        Vector3f lodMin = new Vector3f(lodBlockPosMinX, this.worldMinY, lodBlockPosMinZ);
        Vector3f lodMax = new Vector3f(lodBlockPosMinX + lodBlockWidth, this.worldMaxY, lodBlockPosMinZ + lodBlockWidth);
        return this.frustum.testAab(lodMin, lodMax);
    }

    @Override
    public int getPriority() {
        return -1;
    }
}

